package net.w_horse.excelpojo.excel;

import java.lang.annotation.Annotation;


import net.w_horse.excelpojo.annotation.ExcelPOJOAnnotationParser;
import net.w_horse.excelpojo.bean.Utils;
import net.w_horse.excelpojo.excel.reservedword.ReservedWordManager;
import net.w_horse.excelpojo.xml.ExcelPOJOXmlParser;

import org.apache.poi.ss.usermodel.Sheet;
import org.w3c.dom.Element;

public class ConstantValueCellSeeker extends AbstractCellSeeker {

	private String value;
	@Override
	public void set(Element element, ExcelPOJOXmlParser parser) {
		parser.setCellSeeker(element, this);
	}

	@Override
	public void set(Annotation annotation, ExcelPOJOAnnotationParser parser) {
		parser.setCellSeeker(annotation, this);
	}

	@Override
	public boolean verify() throws IllegalArgumentException {
		return true;
	}

	@Override
	public Object seekCellValue(Sheet sheet, Class<?> requiredType) {
		String value = ReservedWordManager.convReservedWord(getValue());
		return Utils.convertIfNecessary(value, requiredType);
	}

	@Override
	protected Offset seekCellPosition(Sheet sheet) {
		return new Offset();
	}

	@Override
	protected Offset seekCellPosition(Sheet sheet, Offset basePosition, Offset offset) {
		return new Offset();
	}

	@Override
	public void setValue(Sheet sheet, Object bean) {
		// ݂ɂĂ͉Ȃ
	}

	@Override
	protected void setValue(Sheet sheet, Offset basePosition,
			Offset offset, Object value) {
		// ݂ɂĂ͉Ȃ
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getValue() {
		return value;
	}

	public void setMargedRows(boolean connectedRows) {
	}


}
